/**
 *  Arduino ethernet keypad door entry sketch.  http://zirafaworks.com/node/10
 *
 *  For educational purposes only. *** Warning: Use at your OWN RISK! ***
 *  Originally written in 2009 - hardware/software dependencies may change.
 *  
 *  Hardware requirements: Arduino, LCD display, Ethernet Shield, 9 digit key
 */

#include <SPI.h>
#include <String.h>
#include <SoftwareSerial.h>
#include <Ethernet.h>

//Keypad library http://playground.arduino.cc/code/Keypad#CurrentVersion
#include <Keypad.h>

#define rxPin 0
#define txPin 2
#define pinBeep 1 

// KEYPAD SETUP
const byte ROWS = 4; //four rows
const byte COLS = 3; //three columns
char keys[ROWS][COLS] = {
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};
byte rowPins[ROWS] = {5, 4, 3, 2}; //connect to the row pinouts of the keypad
byte colPins[COLS] = {8, 7, 6}; //connect to the column pinouts of the keypad
Keypad kpd = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS );


//ETHERNET SETUP

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network:
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
byte ip[] = { 192, 168, 1, 58 };
byte gateway[] = { 192, 168, 1, 1 };   //your router's IP address
byte subnet[] = { 255, 255, 255, 0 };    //subnet mask of the network 
byte server[] = { 64, 233, 187, 99 }; // Google (replace with your server IP)
Client client(server, 80);


// Set up a new serial port to avoid serial garble problem on default pins
SoftwareSerial lcdSerial =  SoftwareSerial(rxPin, txPin);
int i = 0;
char code[5];

void setup() {
  
  pinMode(pinBeep, OUTPUT);
 
  // Setup soft serial pins:
  pinMode(rxPin, INPUT);
  pinMode(txPin, OUTPUT);
  
  //Initialize LCD serial
  lcdSerial.begin(9600);
  resetCodeEntry();

  // Initialize ethernet
  Ethernet.begin(mac, ip, gateway, subnet);
  delay(1000); 
}


void loop() { 
 boolean response = false;
 // Get Key Input
 char key = kpd.getKey();
 delay(10);
 if ( key != '\0') {
   lcdSerial.print(key);
   code[i] = key;  
   i++;
   digitalWrite(pinBeep, HIGH);
   delay(75);
   digitalWrite(pinBeep, LOW);
 }
 if (i > 3) {
   verifyCode(code);
   response = readResponse();
   if (response == true) {
     blinkingBox(0);   
     delay(200);
     clearLCD();
     delay(100);
     lcdSerial.print("WELCOME!");
     delay(5000);
     // Send trigger to door latch relay and open the door!
     // TriggerDoorLatch();
     resetCodeEntry();
   }
   else {
     delay(200);
     clearLCD();
     delay(100);
     blinkingBox(0);
     lcdSerial.print("INVALID CODE");
     delay(500);
     clearLCD();
     delay(500);
     lcdSerial.print("INVALID CODE");
     delay(300);
     clearLCD();
     delay(300);   
     resetCodeEntry();
   }
 }

}


void verifyCode(char code[5]) {
  // We have a code, let's send it to the server via GET (not secure of course!)
  
  // Create a request string array to send to the server. Initialize string with a password of 0000
  char request[] = "GET /~path/to/index.php?q=verifycode&password=0000 HTTP/1.0";
  
  // Simple char array manipulation. Replace the 0000 with actual code typed in. 
  request[46] = code[0];
  request[47] = code[1];
  request[48] = code[2];
  request[49] = code[3];  
  
  int tries = 0;
  int j = 1;
  clearLCD();  
  delay(100);
  lcdSerial.print("Verifying...");
  delay(100);
  
  while (!client.connect()) {
    tries++; 
    if (tries > 100) {                 // Ok we have problem
      Ethernet.begin(mac, ip, gateway, subnet);    // Reset again if still not connected.
      delay(1000);
      lcdSerial.print("."); //Add a . to LCD for each try to show a reset happened.
      tries = 0;
    }
  }
  if (client.connect()) {
    lcdSerial.print("..."); // Client connected to server
    delay(1000);
    // Here we actually send the page request
    client.println(request);
    client.println();
    delay(1000); // maybe shorter or longer?
  } else {
    lcdSerial.println("Connection failed");
  }
}

boolean readResponse() {
 int z = 0;
 char buff[13];
 boolean response = false;
 while (client.available()) {
   // Read the server response through a 13 character buffer
   char c = client.read();
    for (int b = 0; b < 10; b++) {
      buff[b] = buff[b+1];
    }
    buff[10] = c;
    // Code is actually '1234' but server sends it in format 11223344 (simple redundancy) 
    if (buff[0] == '1' && buff[1] == '1' && buff[2] == '2' && buff[3] == '2' && buff[4] == '3' && buff[5] == '3' && buff[6] == '4' && buff[7] == '4') {
      if (buff[10] == '1') {
        response = true;
      } 
      else {
        response = false;
      }
    }
    z++;
  }
  return response;
  /*
  if (!client.connected()) {
    lcdSerial.println();
    lcdSerial.println("disconnecting.");
    client.stop();
    for(;;)
      ;
  }
  */
}

void resetCodeEntry() {
   i = 0;
   clearLCD();
   delay(100);
   lcdSerial.print("Enter code:");
   delay(100);
   blinkingBox(1);
   backlight(30);
}

void goTo (int position) { 
  //position = line 1: 0-15, line 2: 16-31, 31+ defaults back to 0
  if (position < 16) { 
    lcdSerial.print(0xFE, BYTE);   //command flag          
    lcdSerial.print((position+128), BYTE);    //position
  } else if (position < 32){
    lcdSerial.print(0xFE, BYTE);   //command flag
    lcdSerial.print((position+48+128), BYTE);    //position 
  } else { 
    goTo(0); 
  }
}
void clearLCD(){
   serCommand();   //command flag
   lcdSerial.print(0x01, BYTE);   //clear command.
}

void backlight(int b) {
    // dig is a decimal, 0 is off, .5 is half, 1 is full brightness
    int light;    // map 0-1 to 30 possible values
    light = 128 + b; //128-157 (128 is off, 157 on)
    lcdSerial.print(0x7C, BYTE);  // backlight command
    lcdSerial.print(light, BYTE);
}

void serCommand(){    
  //a general function to call the command flag for issuing all other commands  
  lcdSerial.print(0xFE, BYTE);
}

// Show  a blinking cursor box on the LCD screen
void blinkingBox(int t) {
  // 1 is on, 0 is off
  if (t == 1) {
    serCommand();
    lcdSerial.print( 0x0D, BYTE);  
  }
  else {
    serCommand();
    lcdSerial.print( 0x0C, BYTE);
  }
}

void triggerDoorLatch() {
  // Here you would send a +5 signal to an Arduino pinOut, which be connected to a door relay, opening the door.  
}


void lcdCommand(char cmd[ ]) {

}

/* LCD commands
Clear display 0x01
Move cursor right one 0x14
Move cursor left one 0x10
Scroll right 0x1C
Scroll left 0x18
Turn visual display on 0x0C
Turn visual display off 0x08
Underline cursor on 0x0E
Underline cursor off 0x0C
Blinking box cursor on 0x0D
Blinking box cursor off 0x0C
Set cursor position 0x80
*/

